# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from mysite.pywebsv.utils import request_valid, user_photo, online_employee, interface_response, datetime2stamp, \
    get_sender, MESSAGE_CODE, SUCCESS_CODE, SYSTEM_EXCEPTION, DATA_EXCEPTION, paging
import json


class BioTimeAppNotification(object):

    """
    【Notification】 通知
    """

    @request_valid
    @ladonize(int, int, int, str, str, str, rtype=str)
    def pull_approve_flow(self, category, code, source, device_token, language, token):
        """
        @param category:        类型
        @param code:            对象ID
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:
            请求成功
                {"code":1, "error":"", "describe":"", "message":"", "data":[{"pin":"工号",""name": "姓名", "photo": "照片地址", "approve_status": "审核状态", approve_describe": "审核描述"  "action_time":　操作时间(stamp)}, ]}
                approve_status: 　１:申请，２：审核通过，３：拒绝
            请求失败
                {"code": -10001, "error": "", "describe": "异常详情", "message": "弹窗信息", "data":""}
        """
        from mysite.iclock.models.model_notification import Notification, UNREAD, READ, CATEGORY, SUB_CATEGORY, \
            CATEGORY_LEAVE, CATEGORY_OVERTIME, CATEGORY_MANUAL, CATEGORY_TRAINING, CATEGORY_SCHEDULE, \
            CATEGORY_ANNOUNCEMENT, CATEGORY_ATTENDANCE
        # from mysite.personnel.models.model_dept_approver import DepartmentApprover
        from mysite.att.models.model_approvedhistory import ApprovedHistory, EMPLOYEE_APPROVED, ADMIN_APPROVED
        from mysite.personnel.models.model_dept_approve import SINGLE_LEVEL
        from mysite.att import constant
        profile = None
        if category not in (CATEGORY_LEAVE, CATEGORY_OVERTIME, CATEGORY_MANUAL, CATEGORY_TRAINING, CATEGORY_SCHEDULE, CATEGORY_ANNOUNCEMENT, CATEGORY_ATTENDANCE):
            describe = 'Parameter error'
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)
        data = {
            'category': category,
            'items': []
        }
        if category in (CATEGORY_MANUAL, ):
            from mysite.att.models.checkexact_model import CheckExact
            objs = CheckExact.objects.filter(id=code)
            if objs:
                obj = objs[0]
                profile = {
                    'code': obj.pk,
                    'pin': obj.UserID.PIN,
                    'name': obj.UserID.EName,
                    'department': obj.UserID.DeptID,
                    'approve_status': obj.audit_status,
                    'remark': obj.YUYIN,
                    'action_time': datetime2stamp(obj.create_time)
                }
        elif category in (CATEGORY_LEAVE, ):
            from mysite.att.models.model_empspecday import EmpSpecDay
            objs = EmpSpecDay.objects.filter(id=code)
            if objs:
                obj = objs[0]
                profile = {
                    'code': obj.pk,
                    'pin': obj.emp.PIN,
                    'name': obj.emp.EName,
                    'department': obj.emp.DeptID,
                    'approve_status': obj.audit_status,
                    'remark': obj.reson,
                    'action_time': datetime2stamp(obj.create_time)
                }
        elif category in (CATEGORY_OVERTIME, ):
            from mysite.att.models.model_overtime import OverTime
            objs = OverTime.objects.filter(id=code)
            if objs:
                obj = objs[0]
                profile = {
                    'code': obj.pk,
                    'pin': obj.emp.PIN,
                    'name': obj.emp.EName,
                    'department': obj.emp.DeptID,
                    'approve_status': obj.audit_status,
                    'remark': obj.remark,
                    'action_time': datetime2stamp(obj.create_time)
                }
        elif category in (CATEGORY_TRAINING, ):
            from mysite.att.models.model_training import Training
            objs = Training.objects.filter(id=code)
            if objs:
                obj = objs[0]
                profile = {
                    'code': obj.pk,
                    'pin': obj.emp.PIN,
                    'name': obj.emp.EName,
                    'department': obj.emp.DeptID,
                    'approve_status': obj.audit_status,
                    'remark': obj.remark,
                    'action_time': datetime2stamp(obj.create_time)
                }
        elif category in (CATEGORY_SCHEDULE, ):
            from mysite.att.models.model_schedule import ChangeSchedule
            objs = ChangeSchedule.objects.filter(id=code)
            if objs:
                obj = objs[0]
                profile = {
                    'code': obj.pk,
                    'pin': obj.emp.PIN,
                    'name': obj.emp.EName,
                    'department': obj.emp.DeptID,
                    'approve_status': obj.audit_status,
                    'remark': obj.remark,
                    'action_time': datetime2stamp(obj.create_time)
                }
        if profile:
            from mysite.att.global_cache import CACHE_DEPT_APPROVER
            from ordereddict import OrderedDict
            dept_lvs = CACHE_DEPT_APPROVER.get()
            lvs = dept_lvs.get(profile['department'].code, [])
            status = dict(constant.ALL_STATUS)
            item = {
                'pin': profile['pin'],
                'name': profile['name'] or profile['pin'],
                'photo': user_photo(profile['pin']),
                'approve_status': constant.APPLICATION,
                'approve_describe': u'{0}'.format(status[constant.APPLICATION]),
                'remark': profile['remark'],
                'action_time': profile['action_time']
            }
            data['items'].append(item)
            flow_items = []
            history = ApprovedHistory.objects.filter(obj=profile['code'], category=category).values_list('level', 'approved_status', 'approver_type', 'approver', 'action_time', 'remark', 'approver_name')
            hts = OrderedDict()
            for ht in history:
                sender = system_sender = ''
                if ht[2] is EMPLOYEE_APPROVED:
                    sender = ht[3]
                else:
                    system_sender = ht[3]
                sender = get_sender({'system_sender': system_sender, 'sender': sender})
                approve_status = ht[1]
                if approve_status in (constant.CANCEL_AUDIT_SUCCESS, ):
                    approve_status = constant.REFUSE
                hts[ht[0]] = {
                    'name': sender['name'], 'photo': sender['photo'], 'approve_status': approve_status,
                    'approve_describe': u'{0}'.format(status[ht[1]]), 'action_time': datetime2stamp(ht[4]),
                    'approver_type': ht[2], 'remark': ht[5]
                }
            print hts
            approve_level = 0
            if lvs:
                pre_level = 0
                for lv in lvs:
                    cur_level = lv['approve_level']
                    item = hts.get(cur_level, {
                        'pin': lv['approver__PIN'],
                        'name': lv['approver__EName'] or lv['approver__PIN'],
                        'photo': user_photo(lv['approver__PIN']),
                        'approve_status': '',
                        'approve_describe': 'Pending',
                        'remark': '',
                        'action_time': ''
                    })
                    if cur_level is pre_level:
                        continue
                    pre_level = cur_level
                    approve_level = cur_level + 1
                    if item.get('approver_type', None) in (ADMIN_APPROVED, ):
                        item.pop('approver_type')
                        flow_items.append(item)
                        break
                    elif lv['approve__approve_type'] is SINGLE_LEVEL and item['approve_status'] is constant.AUDIT_SUCCESS:
                        break
                    else:
                        if lv['approver__PIN'] == profile['pin']:
                            flow_items = []
                        else:
                            flow_items.append(item)
                item = hts.get(approve_level, None)
                if item:
                    flow_items.append(item)
            else:
                for k, v in hts.iteritems():
                    flow_items.append(v)
            data['items'].extend(flow_items)

        print "[*]Data:", data
        return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')

    @request_valid
    @ladonize(int, int, int, str, str, str, rtype=str)
    def pull_notification(self, category, page_num, source, device_token, language, token):
        """
        通知提醒
        @param category:
            通知类型 (1:Leave, 2:Overtime, 3:Manual Punch, 4:Training, 5:Schedule, 6:Announcement, 7:Attendance)
            category=0时返回未读信息数
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回结果
            请求成功：
                category=0
                    {"code":1,"error":"","describe":"","message":"","data":[
                        {"category": 1, "category_name": 'leave', 'category_label': "标题名称", "unread": 未读通知数},
                        {"category": 2, "category_name": 'overtime', 'category_label': "标题名称", "unread': 未读通知数},
                        {"category": 3, "category_name": 'manual', 'category_label': "标题名称", "unread': 未读通知数},
                        {"category": 4, "category_name": 'training', 'category_label': "标题名称", 'unread': 未读通知数},
                        {"category": 5, "category_name": 'schedule', 'category_label': "标题名称", 'unread': 未读通知数},
                        {"category": 6, "category_name": 'announcement', 'category_label': "标题名称", 'unread': 未读通知数},
                        {"category": 7, "category_name": 'attendance', 'category_label': "标题名称", 'unread': 未读通知数},
                    ]}
                category in (1, 2, 3, 4, 5, 6, 7)
                    category=1（请假）
                        {"code":1,"error":"","describe":"","message":"","data":{
                            "category": 1,
                            "items":[{"code":对象ID,"name":"姓名","photo":"照片地址","category":"标题","start":"请假开始时间(stamp)","end":"请假结束时间(stamp)","remark":"申请备注","apply_time":"申请时间(stamp)","approve_status":"审批状态值","approve_describe":"审批状态"}，]
                        }]
                    category=２（加班）
                        {"code":1,"error":"","describe":"","message":"","data":{
                            "category":2,
                            "items":[{"code":对象ID,"name":"姓名","photo":"照片地址","category":"标题","start":"加班开始时间(stamp)","end":"加班结束时间(stamp)","remark":"申请备注","apply_time":"申请时间(stamp)","approve_status":"审批状态值","approve_describe":"审批状态"}，]
                        }]
                    category=3（补签）
                        {"code":1,"error":"","describe":"","message":"","data":{
                            "category":３,
                            "items":[{"code":对象ID,"name":"姓名","photo":"照片地址","category":"标题","punch_time":"签卡时间(stamp)","remark":"申请备注","apply_time":"申请时间(stamp)","approve_status":"审批状态值","approve_describe":"审批状态"}，]
                        }]
                    category=4（培训）
                        {"code":1,"error":"","describe":"","message":"","data":{
                            "category":４,
                            "items":[{"code":对象ID,"name":"姓名","photo":"照片地址","category":"标题","start":"培训开始时间(stamp)","end":"培训结束时间(stamp)","remark":"申请备注","apply_time":"申请时间(stamp)","approve_status":"审批状态值","approve_describe":"审批状态"}，]
                        }]
                    category=５（调班）
                        {"code":1,"error":"","describe":"","message":"","data":{
                            "category":５,
                            "items":[{"code":对象ID,"name":"姓名","photo":"照片地址","category":"标题","previous_shift":"当前班次","currently_shift":"申请调整的班次","remark":"申请备注","apply_time":"申请时间(stamp)","approve_status":"审批状态值","approve_describe":"审批状态"}，]
                        }]
                    category=６（公告）
                        {"code":1,"error":"","describe":"","message":"","data":{
                            "category":６,
                            "items":[{"code":对象ID,"name":"姓名","photo":"照片地址","category":"标题","category_val":"类型值(1:Public, 2:Private)","subject":"公告标题","content":"公告内容","notification_time":"通知时间(stamp)"}，]
                        }]
                    category=７（考勤异常）
                        {"code":1,"error":"","describe":"","message":"","data":{
                            "category":７,
                            "items":[{"code":对象ID,"name":"姓名","photo":"照片地址","category":"标题","category_val":"类型值(1:迟到,2:早退,3:旷工)","content":"通知内容","notification_time":"通知时间(stamp)"}，]
                        }]
            请求失败
                {"code": -10001, "error": "", "describe": "异常详情", "message": "弹窗信息", "data":""}
        """
        from mysite.iclock.models.model_notification import Notification, UNREAD, READ, CATEGORY, SUB_CATEGORY, \
            CATEGORY_LEAVE, CATEGORY_OVERTIME, CATEGORY_MANUAL, CATEGORY_TRAINING, CATEGORY_SCHEDULE, \
            CATEGORY_ANNOUNCEMENT, CATEGORY_ATTENDANCE
        from mysite.sql_utils import get_sql, p_query, p_execute
        from mysite.att import constant
        from django.db.models import Count
        import datetime
        emp = online_employee()
        page_num = page_num or 1
        if category:
            sub_category = dict(SUB_CATEGORY)
            data = {
                'category': category,
                'items': []
            }
            sql = get_sql('sql', sqlid='notification', app="pywebsv", params={'category': category, 'receiver': emp.pk})
            sql = paging(sql, page_num, 'notification_time')
            rows = p_query(sql)
            vals = []
            if rows:
                vals = [{'sub_category': r[0], 'sender': r[1], 'system_sender': r[2], 'content': r[3], 'source': r[4], 'notification_time': r[5]} for r in rows]
                params = {'category': category, 'receiver': emp.pk, 'read_time': u'{0}'.format(datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S'))}
                update_status = get_sql('sql', sqlid='read_notification', app="pywebsv", params=params)
                p_execute(update_status)
            for val in vals:
                sender = get_sender(val)
                if category in (CATEGORY_LEAVE, CATEGORY_OVERTIME, CATEGORY_TRAINING):
                    '''
                    Leave, Overtime, Training
                    '''
                    item = {
                        'code': val['source'], 'name': sender['name'], 'photo': sender['photo'],
                        "category": "", "start": "", "end": "", "remark": "",
                        "apply_time": "", "approve_status": "", "approve_describe": ""
                    }
                    if val['content']:
                        detail = json.loads(val['content'])
                        approve_status = detail['approve_status']
                        if approve_status in (constant.AUDITING, ):
                            approve_status = constant.AUDIT_SUCCESS
                        elif approve_status in (constant.CANCEL_AUDIT_SUCCESS, ):
                            approve_status = constant.REFUSE
                        item.update({
                            'category': detail['category'],  'start': detail['start'],
                            'end': detail['end'], 'remark': detail['remark'],
                            'apply_time': detail['apply_time'],
                            'approve_status': approve_status, 'approve_describe': detail['approve_describe'],
                        })
                    data['items'].append(item)
                elif category in (CATEGORY_MANUAL, ):
                    '''
                    Manual Punch
                    '''
                    item = {
                        'code': val['source'], 'name': sender['name'], 'photo': sender['photo'],
                        "category": "", "punch_time": "", "remark": "",
                        "apply_time": "", "approve_status": "", "approve_describe": ""
                    }
                    if val['content']:
                        detail = json.loads(val['content'])
                        approve_status = detail['approve_status']
                        if approve_status in (constant.AUDITING, ):
                            approve_status = constant.AUDIT_SUCCESS
                        elif approve_status in (constant.CANCEL_AUDIT_SUCCESS, ):
                            approve_status = constant.REFUSE
                        item.update({
                            'category': detail['category'], 'punch_time': detail['punch_time'],
                            'remark': detail['remark'], 'apply_time': detail['apply_time'],
                            'approve_status': approve_status, 'approve_describe': detail['approve_describe'],
                        })
                    data['items'].append(item)
                elif category in (CATEGORY_SCHEDULE, ):
                    '''
                    Change schedule
                    '''
                    item = {
                        'code': val['source'], 'name': sender['name'], 'photo': sender['photo'],
                        "category": "", "previous_shift": "", "currently_shift": "", "remark": "",
                        "apply_time": "", "approve_status": "", "approve_describe": ""
                    }
                    if val['content']:
                        detail = json.loads(val['content'])
                        approve_status = detail['approve_status']
                        if approve_status in (constant.AUDITING, ):
                            approve_status = constant.AUDIT_SUCCESS
                        elif approve_status in (constant.CANCEL_AUDIT_SUCCESS, ):
                            approve_status = constant.REFUSE
                        item.update({
                            'category': detail['category'], 'previous_shift': detail['previous_shift'] or 'None',
                            'currently_shift': detail['currently_shift'], 'remark': detail['remark'],
                            'apply_time': detail['apply_time'],
                            'approve_status': approve_status, 'approve_describe': detail['approve_describe'],
                        })
                    data['items'].append(item)
                elif category in (CATEGORY_ANNOUNCEMENT, ):
                    '''
                    Announcement
                    '''
                    item = {
                        'code': val['source'], 'name': sender['name'], 'photo': sender['photo'],
                        'subject': '', 'content': '',
                        'category': u'{0}'.format(sub_category.get(val['sub_category'], '')),
                        'category_val': val['sub_category'], 'notification_time': datetime2stamp(val['notification_time'])
                    }
                    if val['content']:
                        detail = json.loads(val['content'])
                        item.update(detail)
                    data['items'].append(item)
                elif category in (CATEGORY_ATTENDANCE, ):
                    item = {
                        'code': val['source'],
                        'name': sender['name'],
                        'photo': sender['photo'],
                        "category": u'{0}'.format(sub_category.get(val['sub_category'], '')),
                        "category_val": val['sub_category'],
                        "content": json.loads(val['content']),
                        "notification_time": datetime2stamp(val['notification_time'])
                    }
                    data['items'].append(item)
        else:
            categorys = dict(CATEGORY)
            nfcs = Notification.objects.filter(receiver=emp, read_status=UNREAD).order_by('category').values('category').annotate(unread=Count('category'))
            data = [
                {'category': 1, 'category_name': 'leave', 'category_label': u'{0}'.format(categorys[1]), 'unread': 0},
                {'category': 2, 'category_name': 'overtime', 'category_label': u'{0}'.format(categorys[2]), 'unread': 0},
                {'category': 3, 'category_name': 'manual', 'category_label': u'{0}'.format(categorys[3]), 'unread': 0},
                {'category': 4, 'category_name': 'training', 'category_label': u'{0}'.format(categorys[4]), 'unread': 0},
                {'category': 5, 'category_name': 'schedule', 'category_label': u'{0}'.format(categorys[5]), 'unread': 0},
                {'category': 6, 'category_name': 'announcement', 'category_label': u'{0}'.format(categorys[6]), 'unread': 0},
                {'category': 7, 'category_name': 'attendance', 'category_label': u'{0}'.format(categorys[7]), 'unread': 0},
            ]
            for nfc in nfcs:
                category_index = (nfc['category'] - 1)
                item = data[category_index]
                item['unread'] = nfc['unread']
                data[category_index] = item
        return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')

